function  u_pseudo_surface = get_pseudo_surface(u)
% % data_2D = weighted_summation(weight_3D, loc_rhs, data);
% % data_inter = denoise_interp_output(lambda, w, RHS)
%% size of the solution
[lxs,lys,lzs] = size(u);
%% generating depth data
depth_data = double(u > 0);
for j = 1:lxs
    depth_data(j,:,:) = j * depth_data(j,:,:);
end
%% generating location
loc = double(squeeze(sum(u,1)) > 0);
%% Step 1: Generating 2D depth with 3D albedo values
depth_2D = weighted_summation(u.^2, loc, depth_data);
depth_2D(isnan(depth_2D)) = 0;
depth_2D_inter = denoise_interp_output(2 * loc, 0.02, depth_2D);    % lambda, w, d; lambda to be changed
% iscp(depth_2D,depth_2D_inter)
%% Step 2: Determining 2D albedo values with depth and 3D albedo values
depth_data(depth_data == 0) = NaN;
depth_2D(depth_2D == 0) = NaN;
temp_weight = abs(permute(repmat(round(depth_2D),1,1,lxs),[3,1,2]) - depth_data).^(-2);
temp_weight(temp_weight == inf) = 2;
albedo_2D = weighted_summation(temp_weight, loc, u);
albedo_2D(isnan(albedo_2D)) = 0;
albedo_2D_inter = denoise_interp_output(loc, 1, albedo_2D);
albedo_2D_inter = albedo_2D_inter / max(albedo_2D_inter(:));

%% mask
% u_mask = zeros(lxs,lys,lzs);
% for j = 1 : lys
%     for k = 1:lzs
%         if isnan(depth_2D(j,k)), continue, end
%         u_mask(round(depth_2D(j,k)),j,k) = albedo_2D_inter(j,k);
%     end
% end
mask = determine_mask(u);

%% albedo
% temp_weight = albedo_2D_inter / max(albedo_2D_inter(:));
% temp_weight(albedo_2D < 0.1 * max(albedo_2D(:))) = 1.5;
% data_inter = denoise_interp_output(temp_weight, 0.1, albedo_2D);
% mask = data_inter >= 0.5 * max(data_inter(:));
% mask = ones(lys,lzs);
%% Output solution
u_pseudo_surface = zeros(lxs,lys,lzs);
for j = 1 : lys
    for k = 1:lzs
        if mask(j,k) == 0, continue, end
        u_pseudo_surface(round(depth_2D_inter(j,k)),j,k) = albedo_2D_inter(j,k);
    end
end
end